<?php
/*
Plugin Name: Property Calculator
Plugin URI: https://aulisuwais.com/wordpress-plugin/
Description: A clean and modern calculator plugin that includes Home Loan, Loan, Stamp Duty, and Legal Fee calculators. 6.2.1 removes color customization for a simplified, consistent black-and-white theme. Includes label customization, amortization toggle, region presets, and reset functionality.
Version: 6.2.1
Author: Aulis Uwais
Author URI: https://aulisuwais.com/wordpress-plugin/
License: GPL2
*/
if ( ! defined('ABSPATH') ) exit;

define('PC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('PC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PC_PLUGIN_VER', '6.2.1');

// Always enqueue on frontend to support page builders (e.g., Thrive Architect)
function pc_enqueue_assets_always(){ if ( is_admin() ) return;
  wp_enqueue_style('pc-styles', PC_PLUGIN_URL.'assets/pc-styles.css', array(), PC_PLUGIN_VER);
  wp_enqueue_script('pc-scripts', PC_PLUGIN_URL.'assets/pc-scripts.js', array(), PC_PLUGIN_VER, true);
}
add_action('wp_enqueue_scripts','pc_enqueue_assets_always', 20);

// Admin assets
function pc_admin_assets($hook){
  if ( strpos($hook,'property-calculator') === false ) return;
  wp_enqueue_style('pc-admin', PC_PLUGIN_URL.'assets/pc-admin.css', array(), PC_PLUGIN_VER);
  wp_enqueue_script('pc-admin', PC_PLUGIN_URL.'assets/pc-admin.js', array('jquery'), PC_PLUGIN_VER, true);
}
add_action('admin_enqueue_scripts','pc_admin_assets');

require_once PC_PLUGIN_DIR.'includes/shortcodes.php';
require_once PC_PLUGIN_DIR.'admin/settings.php';
require_once PC_PLUGIN_DIR.'includes/admin-guide.php';
