<?php
if ( ! defined('ABSPATH') ) exit;

function pc_defaults(){
  return array(
    'home_title'=>'Home Loan Calculator','home_price'=>'Total Purchase Price (RM):','home_margin'=>'Margin of Finance (%):','home_rate'=>'Interest Rate (% p.a.):','home_years'=>'Loan Tenure (years):',
    'loan_title'=>'Loan Calculator','loan_amount'=>'Loan Amount (RM):','loan_rate'=>'Interest Rate (% p.a.):','loan_years'=>'Tenure (years):',
    'stamp_title'=>'Stamp Duty Calculator (Malaysia)','stamp_price'=>'Property Price (RM):',
    'legal_title'=>'Legal Fee Calculator (Malaysia)','legal_price'=>'Property Price (RM):',
    'show_home'=>'1','show_loan'=>'1','show_stamp'=>'1','show_legal'=>'1',
    'region'=>'peninsula',
    'tiers_peninsula'=>'500000:1.25;7500000:1;Infinity:1',
    'tiers_sabah'=>'500000:1.25;7500000:1;Infinity:1',
    'tiers_sarawak'=>'500000:1.25;7500000:1;Infinity:1',
    'show_amortization'=>'0'
  );
}
function pc_get_settings(){ $opts=get_option('pc_settings',array()); return wp_parse_args($opts, pc_defaults()); }

function pc_body_data(){
  $s = pc_get_settings();
  $tiers = ($s['region']==='sabah') ? $s['tiers_sabah'] : (($s['region']==='sarawak') ? $s['tiers_sarawak'] : $s['tiers_peninsula']);
  add_action('wp_footer', function() use ($s, $tiers){
    echo '<script>document.body.setAttribute("data-pc-region","'.esc_js($s['region']).'");document.body.setAttribute("data-pc-legal-tiers","'.esc_js($tiers).'");document.body.setAttribute("data-pc-amort","'.esc_js($s['show_amortization']).'");</script>';
  });
}
add_action('wp','pc_body_data');

function home_loan_calculator_shortcode(){
  $s = pc_get_settings();
  ob_start(); ?>
  <div class="pc-box" id="pc-home-loan">
    <h4><?php echo esc_html($s['home_title']); ?></h4>
    <div class="pc-field"><label class="pc-label" for="pc_home_price"><?php echo esc_html($s['home_price']); ?></label><input class="pc-input" type="number" id="pc_home_price" placeholder="e.g. 500000"></div>
    <div class="pc-field"><label class="pc-label" for="pc_home_margin"><?php echo esc_html($s['home_margin']); ?></label><input class="pc-input" type="number" id="pc_home_margin" value="80"></div>
    <div class="pc-field"><label class="pc-label" for="pc_home_rate"><?php echo esc_html($s['home_rate']); ?></label><input class="pc-input" type="number" id="pc_home_rate" value="6.6"></div>
    <div class="pc-field"><label class="pc-label" for="pc_home_years"><?php echo esc_html($s['home_years']); ?></label><input class="pc-input" type="number" id="pc_home_years" value="30"></div>
    <button type="button" class="pc-btn" data-type="home">Calculate</button>
    <div class="pc-result" id="pc_home_result"></div>
  </div>
  <?php return ob_get_clean();
}
add_shortcode('home_loan_calculator','home_loan_calculator_shortcode');

function loan_calculator_shortcode(){
  $s = pc_get_settings();
  ob_start(); ?>
  <div class="pc-box" id="pc-loan">
    <h4><?php echo esc_html($s['loan_title']); ?></h4>
    <div class="pc-field"><label class="pc-label" for="pc_loan_amount"><?php echo esc_html($s['loan_amount']); ?></label><input class="pc-input" type="number" id="pc_loan_amount"></div>
    <div class="pc-field"><label class="pc-label" for="pc_loan_rate"><?php echo esc_html($s['loan_rate']); ?></label><input class="pc-input" type="number" id="pc_loan_rate" value="6.6"></div>
    <div class="pc-field"><label class="pc-label" for="pc_loan_years"><?php echo esc_html($s['loan_years']); ?></label><input class="pc-input" type="number" id="pc_loan_years" value="5"></div>
    <button type="button" class="pc-btn" data-type="loan">Calculate</button>
    <div class="pc-result" id="pc_loan_result"></div>
  </div>
  <?php return ob_get_clean();
}
add_shortcode('loan_calculator','loan_calculator_shortcode');

function stamp_duty_calculator_shortcode(){
  $s = pc_get_settings();
  ob_start(); ?>
  <div class="pc-box" id="pc-stamp">
    <h4><?php echo esc_html($s['stamp_title']); ?></h4>
    <div class="pc-field"><label class="pc-label" for="pc_stamp_price"><?php echo esc_html($s['stamp_price']); ?></label><input class="pc-input" type="number" id="pc_stamp_price"></div>
    <button type="button" class="pc-btn" data-type="stamp">Calculate</button>
    <div class="pc-result" id="pc_stamp_result"></div>
  </div>
  <?php return ob_get_clean();
}
add_shortcode('stamp_duty_calculator','stamp_duty_calculator_shortcode');

function legal_fee_calculator_shortcode(){
  $s = pc_get_settings();
  ob_start(); ?>
  <div class="pc-box" id="pc-legal">
    <h4><?php echo esc_html($s['legal_title']); ?></h4>
    <div class="pc-field"><label class="pc-label" for="pc_legal_price"><?php echo esc_html($s['legal_price']); ?></label><input class="pc-input" type="number" id="pc_legal_price"></div>
    <button type="button" class="pc-btn" data-type="legal">Calculate</button>
    <div class="pc-result" id="pc_legal_result"></div>
  </div>
  <?php return ob_get_clean();
}
add_shortcode('legal_fee_calculator','legal_fee_calculator_shortcode');

function all_property_calculators_shortcode(){
  $s = pc_get_settings();
  ob_start(); ?>
  <div class="pc-grid">
    <?php if ($s['show_home']==='1') echo home_loan_calculator_shortcode(); ?>
    <?php if ($s['show_loan']==='1') echo loan_calculator_shortcode(); ?>
    <?php if ($s['show_stamp']==='1') echo stamp_duty_calculator_shortcode(); ?>
    <?php if ($s['show_legal']==='1') echo legal_fee_calculator_shortcode(); ?>
  </div>
  <?php return ob_get_clean();
}
add_shortcode('all_property_calculators','all_property_calculators_shortcode');
