(function(){
  function num(id){ var el=document.getElementById(id); return el?parseFloat(el.value):NaN; }
  function fmt(n){ if(!isFinite(n))return'0.00'; try{return Number(n).toLocaleString('en-MY',{minimumFractionDigits:2,maximumFractionDigits:2});}catch(e){return n.toFixed(2);} }
  function buildAmort(p,r,m,out,show){
    var pay=(p*r)/(1-Math.pow(1+r,-m));var bal=p,rows=[];
    for(var i=1;i<=m;i++){var intr=bal*r;var prin=pay-intr;bal=Math.max(0,bal-prin);rows.push([i,pay,prin,intr,bal]);}
    var wrap=document.createElement('div');wrap.className='pc-amort-wrap';
    var t=document.createElement('div');t.className='pc-amort-toggle';t.textContent=(show?'Hide':'Show')+' amortization table';
    var tbl=document.createElement('div');tbl.className='pc-amort';tbl.style.display=show?'block':'none';
    var html='<table><thead><tr><th>Month</th><th>Payment</th><th>Principal</th><th>Interest</th><th>Balance</th></tr></thead><tbody>';
    for(var k=0;k<rows.length;k++){var r0=rows[k];html+='<tr><td>'+r0[0]+'</td><td>'+fmt(r0[1])+'</td><td>'+fmt(r0[2])+'</td><td>'+fmt(r0[3])+'</td><td>'+fmt(r0[4])+'</td></tr>';} html+='</tbody></table>'; tbl.innerHTML=html;
    t.addEventListener('click',function(){tbl.style.display=tbl.style.display==='none'?'block':'none';t.textContent=(tbl.style.display==='none'?'Show':'Hide')+' amortization table';});
    wrap.appendChild(t);wrap.appendChild(tbl);out.appendChild(wrap);
  }
  function parseTiers(s){var parts=(s||'').split(';'),tiers=[];for(var i=0;i<parts.length;i++){var kv=parts[i].trim();if(!kv)continue;var p=kv.split(':');var cap=p[0].trim()==='Infinity'?Infinity:parseFloat(p[0].trim());var rate=parseFloat(p[1].trim())/100;if(!isFinite(cap)&&p[0].trim()!=='Infinity')continue;if(!isFinite(rate))continue;tiers.push({cap:cap,rate:rate});}return tiers;}
  function legalFeeFromTiers(a,tiers){var fee=0,prev=0;for(var i=0;i<tiers.length;i++){var cap=tiers[i].cap;if(a>prev){var tax=Math.min(a,cap)-prev;if(tax>0)fee+=tax*tiers[i].rate;prev=cap;}}return fee;}
  function clamp(n,min,max){return Math.min(Math.max(n,min),max);}

  function calcHome(){var price=clamp(num('pc_home_price'),0,1e12);var margin=clamp(num('pc_home_margin'),0,100);var rate=clamp(num('pc_home_rate'),0,100)/100/12;var years=clamp(num('pc_home_years'),1,50);var months=years*12;
    var out=document.getElementById('pc_home_result');var show=document.body.getAttribute('data-pc-amort')==='1';if([price,margin,rate,years].some(function(x){return isNaN(x);})){out.innerHTML='<p>Please fill in all fields correctly.</p>';return;}
    var loan=price*(margin/100); if(rate===0){var m0=loan/months;out.innerHTML='<p><strong>Total Loan Amount:</strong> RM '+fmt(loan)+'</p><p><strong>Monthly Installment:</strong> RM '+fmt(m0)+'</p>'; if(show)buildAmort(loan,rate,months,out,false); return;}
    var m=(loan*rate)/(1-Math.pow(1+rate,-months)); out.innerHTML='<p><strong>Total Loan Amount:</strong> RM '+fmt(loan)+'</p><p><strong>Monthly Installment:</strong> RM '+fmt(m)+'</p>'; if(show)buildAmort(loan,rate,months,out,false);}

  function calcLoan(){var a=clamp(num('pc_loan_amount'),0,1e12);var rate=clamp(num('pc_loan_rate'),0,100)/100/12;var years=clamp(num('pc_loan_years'),1,50);var months=years*12;
    var out=document.getElementById('pc_loan_result');var show=document.body.getAttribute('data-pc-amort')==='1'; if([a,rate,years].some(function(x){return isNaN(x);})){out.innerHTML='<p>Please fill in all fields correctly.</p>';return;}
    if(rate===0){var m0=a/months;out.innerHTML='<p><strong>Monthly Payment:</strong> RM '+fmt(m0)+'</p><p><strong>Total Payment:</strong> RM '+fmt(a)+'</p><p><strong>Total Interest:</strong> RM 0.00</p>'; if(show)buildAmort(a,rate,months,out,false); return;}
    var m=(a*rate)/(1-Math.pow(1+rate,-months));var tot=m*months;var intr=tot-a;out.innerHTML='<p><strong>Monthly Payment:</strong> RM '+fmt(m)+'</p><p><strong>Total Payment:</strong> RM '+fmt(tot)+'</p><p><strong>Total Interest:</strong> RM '+fmt(intr)+'</p>'; if(show)buildAmort(a,rate,months,out,false);}

  function calcStamp(){var price=num('pc_stamp_price');var out=document.getElementById('pc_stamp_result');if(isNaN(price)){out.innerHTML='<p>Please enter the property price.</p>';return;}
    var d=0;if(price<=100000){d=price*0.01;}else if(price<=500000){d=100000*0.01+(price-100000)*0.02;}else if(price<=1000000){d=100000*0.01+400000*0.02+(price-500000)*0.03;}else{d=100000*0.01+400000*0.02+500000*0.03+(price-1000000)*0.04;}
    out.innerHTML='<p><strong>Estimated Stamp Duty (SPA/Transfer):</strong> RM '+fmt(d)+'</p>';}

  function calcLegal(){var price=num('pc_legal_price');var out=document.getElementById('pc_legal_result');if(isNaN(price)){out.innerHTML='<p>Please enter the property price.</p>';return;}
    var region=document.body.getAttribute('data-pc-region')||'peninsula';var tiers=parseTiers(document.body.getAttribute('data-pc-legal-tiers')); if(tiers.length===0){tiers=[{cap:500000,rate:0.0125},{cap:7500000,rate:0.01},{cap:Infinity,rate:0.01}];}
    var fee=legalFeeFromTiers(price,tiers); out.innerHTML='<p><strong>Estimated Legal Fee ('+region+'): </strong> RM '+fmt(fee)+'</p><p style="font-size:12px">Subject to SRO and firm quote.</p>'; }

  document.addEventListener('click',function(e){var t=e.target;if(!t.classList.contains('pc-btn'))return;var type=t.getAttribute('data-type');if(type==='home')calcHome();if(type==='loan')calcLoan();if(type==='stamp')calcStamp();if(type==='legal')calcLegal();});
})();
