<?php
if ( ! defined('ABSPATH') ) exit;

function pc_settings_menu(){ add_menu_page('Property Calculator','Property Calculator','manage_options','property-calculator','pc_settings_page','dashicons-calculator',81); }
add_action('admin_menu','pc_settings_menu');

function pc_register_settings(){ register_setting('pc_settings_group','pc_settings','pc_sanitize_settings'); }
add_action('admin_init','pc_register_settings');

function pc_sanitize_settings($input){
  $out=array();
  foreach(array('home_title','home_price','home_margin','home_rate','home_years','loan_title','loan_amount','loan_rate','loan_years','stamp_title','stamp_price','legal_title','legal_price') as $k){
    $out[$k]=sanitize_text_field(isset($input[$k])?$input[$k]:''); }
  foreach(array('show_home','show_loan','show_stamp','show_legal','show_amortization') as $k){ $out[$k]=(isset($input[$k])&&$input[$k]=='1')?'1':'0'; }
  $allowed_regions=array('peninsula','sabah','sarawak'); $out['region']=in_array(isset($input['region'])?$input['region']:'peninsula',$allowed_regions,true)?$input['region']:'peninsula';
  foreach(array('tiers_peninsula','tiers_sabah','tiers_sarawak') as $k){
    $raw=isset($input[$k])?$input[$k]:''; $parts=array_filter(array_map('trim', explode(';',$raw))); $valid=array();
    foreach($parts as $p){ $kv=array_map('trim', explode(':',$p)); if(count($kv)!==2) continue; $cap_raw=$kv[0]; $rate_raw=$kv[1];
      if (strcasecmp($cap_raw,'Infinity')===0){ $cap='Infinity'; } else { if(!is_numeric($cap_raw)) continue; $cap=(float)$cap_raw; if($cap<0) continue; }
      if(!is_numeric($rate_raw)) continue; $rate=(float)$rate_raw; if($rate<0||$rate>100) continue; $valid[]=($cap==='Infinity'?'Infinity':$cap).':'.$rate; }
    $has_infinity=false; foreach($valid as $v){ if(strpos($v,'Infinity:')===0){$has_infinity=true;break;} } if(!$has_infinity) $valid[]='Infinity:1';
    $out[$k]=implode(';',$valid);
  }
  return $out;
}

function pc_input($name,$label,$opts){ $val=isset($opts[$name])?$opts[$name]:''; echo '<div class="pc-field"><label>'.$label.'</label><input type="text" name="pc_settings['.$name.']" value="'.esc_attr($val).'" /></div>'; }
function pc_switch($name,$label,$opts){ $val=isset($opts[$name])?$opts[$name]:'1'; $checked=$val==='1'?'checked':''; echo '<label class="pc-switch"><input type="checkbox" name="pc_settings['.$name.']" value="1" '.$checked.' /> '.$label.'</label>'; }
function pc_textarea($name,$label,$opts,$note=''){ $val=isset($opts[$name])?$opts[$name]:''; echo '<div class="pc-field"><label>'.$label.'</label><textarea name="pc_settings['.$name.']">'.esc_textarea($val).'</textarea>'; if($note) echo '<p class="pc-note">'.$note.'</p>'; echo '</div>'; }

function pc_handle_reset_defaults(){ if(isset($_GET['pc_reset'])&&current_user_can('manage_options')&&check_admin_referer('pc_reset_defaults')){ delete_option('pc_settings'); wp_redirect(admin_url('admin.php?page=property-calculator&pc_reset_done=1')); exit; } }
add_action('admin_init','pc_handle_reset_defaults');

function pc_settings_page(){
  $defaults=array('home_title'=>'Home Loan Calculator','home_price'=>'Total Purchase Price (RM):','home_margin'=>'Margin of Finance (%):','home_rate'=>'Interest Rate (% p.a.):','home_years'=>'Loan Tenure (years):','loan_title'=>'Loan Calculator','loan_amount'=>'Loan Amount (RM):','loan_rate'=>'Interest Rate (% p.a.):','loan_years'=>'Tenure (years):','stamp_title'=>'Stamp Duty Calculator (Malaysia)','stamp_price'=>'Property Price (RM):','legal_title'=>'Legal Fee Calculator (Malaysia)','legal_price'=>'Property Price (RM):','show_home'=>'1','show_loan'=>'1','show_stamp'=>'1','show_legal'=>'1','region'=>'peninsula','tiers_peninsula'=>'500000:1.25;7500000:1;Infinity:1','tiers_sabah'=>'500000:1.25;7500000:1;Infinity:1','tiers_sarawak'=>'500000:1.25;7500000:1;Infinity:1','show_amortization'=>'0');
  $opts=get_option('pc_settings',array()); $opts=wp_parse_args($opts,$defaults); ?>
  <div class="pc-admin-wrap">
    <div class="pc-admin-head">
      <h1 class="pc-title">Property Calculator — Settings</h1>
      <div class="pc-version-badge">v<?php echo esc_html( defined('PC_PLUGIN_VER') ? PC_PLUGIN_VER : '6.x'); ?></div>
    </div>
    <?php if(isset($_GET['pc_reset_done'])) echo '<div class="notice notice-success"><p>Settings reset to defaults.</p></div>'; ?>
    <p class="pc-sub">Edit labels, region tiers, combined visibility, and amortization tables. Changes apply site‑wide.</p>
    <form method="post" action="options.php"><?php settings_fields('pc_settings_group'); ?>
      <div class="pc-card"><div class="pc-title">Combined Shortcode Visibility</div>
        <div class="pc-grid"><div><?php pc_switch('show_home','Show Home Loan in [all_property_calculators]',$opts); ?></div><div><?php pc_switch('show_loan','Show Loan in [all_property_calculators]',$opts); ?></div><div><?php pc_switch('show_stamp','Show Stamp Duty in [all_property_calculators]',$opts); ?></div><div><?php pc_switch('show_legal','Show Legal Fee in [all_property_calculators]',$opts); ?></div></div>
      </div>
      <div class="pc-card"><div class="pc-title">Amortization Tables</div><?php pc_switch('show_amortization','Enable amortization tables on Home Loan & Loan calculators',$opts); ?><p class="pc-note">A collapsible table appears under results.</p></div>
      <div class="pc-card"><div class="pc-title">Region Preset (Legal Fee)</div>
        <div class="pc-grid">
          <div class="pc-field"><label>Choose Region</label><select name="pc_settings[region]"><option value="peninsula" <?php selected($opts['region'],'peninsula'); ?>>Peninsula Malaysia</option><option value="sabah" <?php selected($opts['region'],'sabah'); ?>>Sabah</option><option value="sarawak" <?php selected($opts['region'],'sarawak'); ?>>Sarawak</option></select></div>
          <?php pc_textarea('tiers_peninsula','Tiers — Peninsula',$opts,'Format: cap:ratePercent;cap:ratePercent;Infinity:ratePercent'); ?>
          <?php pc_textarea('tiers_sabah','Tiers — Sabah',$opts); ?>
          <?php pc_textarea('tiers_sarawak','Tiers — Sarawak',$opts); ?>
        </div>
      </div>
      <div class="pc-card"><div class="pc-title">Labels — Home Loan</div>
        <div class="pc-grid"><?php pc_input('home_title','Title',$opts); ?><?php pc_input('home_price','Price Label',$opts); ?><?php pc_input('home_margin','Margin Label',$opts); ?><?php pc_input('home_rate','Rate Label',$opts); ?><?php pc_input('home_years','Years Label',$opts); ?></div>
      </div>
      <div class="pc-card"><div class="pc-title">Labels — Loan</div>
        <div class="pc-grid"><?php pc_input('loan_title','Title',$opts); ?><?php pc_input('loan_amount','Amount Label',$opts); ?><?php pc_input('loan_rate','Rate Label',$opts); ?><?php pc_input('loan_years','Years Label',$opts); ?></div>
      </div>
      <div class="pc-card"><div class="pc-title">Labels — Stamp Duty</div>
        <div class="pc-grid"><?php pc_input('stamp_title','Title',$opts); ?><?php pc_input('stamp_price','Price Label',$opts); ?></div>
      </div>
      <div class="pc-card"><div class="pc-title">Labels — Legal Fee</div>
        <div class="pc-grid"><?php pc_input('legal_title','Title',$opts); ?><?php pc_input('legal_price','Price Label',$opts); ?></div>
      </div>
      <div class="pc-actions"><?php submit_button('Save Settings','primary','submit',false); ?><a id="pc-reset-defaults" class="button reset" href="<?php echo wp_nonce_url(admin_url('admin.php?page=property-calculator&pc_reset=1'),'pc_reset_defaults'); ?>">Reset to Defaults</a></div>
    </form>
  </div><?php } ?>
